<?php
    /**
    *
    * copyright (c) 2013-2023 Heliac Technologies
    * license http://opensource.org/licenses/gpl-license.php GNU GPL v3 
    *
    * linee guida per l'utilizzo del logo http://www.geecom.org/articolo.php?alias=linee-guida-per-luso-del-logo-geecom
    *
    * 	Classe che restituisce i link scritti con Geecom
    *
    * Classe per gestire le categorie
    */
     
    class Categoria {
        private $db;
        private $id; // se io scrivo private significa che questa variabile è presente solo in questa classe
        private $categoriaMadre;
        private $categoriaRiferimento;
        private $tipo;
        private $lingua;
        private $alias;
        private $nome;
        private $titoloPagina;
        private $metaDescrizione;
        private $cssGenerato;
        private $cssAggiuntivo;
        private $foto;
        private $punteggioSeo;
        private $elementiPerPagina;
        private $tipoVisualizzazione;
        private $posizione;
        private $ordinamento;
        private $datiCategoria;
        
        /* creo il costruttore, ovvero il metodo che crea il nostro oggetto */
        function __construct($db, $id, $categoriaMadre = 0, $categoriaRiferimento = 0, $tipo = "", $lingua = "", $nome = "", $alias = "", $cssGenerato = "", $cssAggiuntivo = "", $foto = "", $tipoVisualizzazione= "", $elementiPerPagina = 0, $posizione = 0, $ordinamento = "") {
            $this->db = $db; // con questo comando sto assegnando il campo $db preso in input alla variabile di classe $db
            $this->id = $id;
            $this->categoriaMadre = $categoriaMadre;
            $this->categoriaRiferimento = $categoriaRiferimento;
            $this->tipo   = $tipo;
            $this->lingua = $lingua;
            $this->alias  = $alias;
            $this->nome   = $nome;
            $this->cssGenerato   = $cssGenerato;
            $this->cssAggiuntivo = $cssAggiuntivo;
            $this->foto          = $foto;
            $this->tipoVisualizzazione = $tipoVisualizzazione;
            $this->elementiPerPagina   = $elementiPerPagina;
            $this->posizione     = $posizione;
            $this->ordinamento   = $ordinamento;
            $this->datiCategoria = array();
        }
        
        /*
         * metodo per la creazione della categoria
         */
        function crea() {
            $this->alias = generaAlias($this->db,$this->nome, "geec_categorie", "nome");
            $data  = date("Y-m-d");
            $query = "INSERT INTO `geec_categorie` (`id`, `categoriaMadre`, `categoriaRiferimento`, `tipo`, `lingua`, `nome`, `alias`, `titoloPagina`, `metaDescrizione`, `cssGenerato`, `cssAggiuntivo`, `foto`, `punteggioSeo`, `tipoVisualizzazione`, `numeroArticoliPerPagina`, `posizione`, `ordinamento`, `dataCreazione`)
                        VALUES (NULL, '$this->categoriaMadre', '$this->categoriaRiferimento', '$this->tipo', '$this->lingua', '$this->nome', '$this->alias', '$this->titoloPagina', '$this->metaDescrizione', '$this->cssGenerato', '$this->cssAggiuntivo', '$this->foto','$this->punteggioSeo','$this->tipoVisualizzazione', '$this->elementiPerPagina', '$this->posizione', '$this->ordinamento', '$data');";
            $this->id = $this->db->eseguiQueryCreazione($query);
            return $this->id;
        }
        
        /*
         * qui va aggiunto un parametro alias che deve essere passato dall'utente
         */
        function modifica() {
            if($this->alias=="") {
                $this->alias = generaAlias($this->db, $this->nome, "geec_categorie", "nome");
            }
            
            $query = "UPDATE `geec_categorie` SET  categoriaMadre='$this->categoriaMadre', tipo='$this->tipo', nome='$this->nome', alias='$this->alias', titoloPagina='$this->titoloPagina', metaDescrizione='$this->metaDescrizione', cssAggiuntivo='$this->cssAggiuntivo', punteggioSeo='$this->punteggioSeo', tipoVisualizzazione='$this->tipoVisualizzazione', numeroArticoliPerPagina='$this->elementiPerPagina',  ordinamento='$this->ordinamento' WHERE id=$this->id";
            $this->db->eseguiQueryScrittura($query);
        }
        
        function elimina() {
            $datiCategoria = $this->db->leggiSingolaRiga("geec_categorie",$this->id);
            $this->db->eseguiQueryCancellazione("geec_categorie",$this->id);
            
            // Gli elementi della tabella interessata (geecEc_prodotti se è una categodia di tipo ecommerce o geecB_contenuti in tuti gli altri  casi)
            // con quella categoria vengono impostati con categoria a 0
            $tabellaDaAggiornare = ($datiCategoria["tipo"]=="ecommerce") ? "geecEc_prodotti" : "geecB_contenuti";
            $query = "UPDATE $tabellaDaAggiornare SET  categoria=0 WHERE categoria=$this->id";
            $this->db->eseguiQueryScrittura($query);
        }
        
        function duplica($prefisso = "Copia di ") {
            $categoriaDaCopiare = $this->db->leggiSingolaRiga("geec_categorie",$this->id);
            
            //calcolo la posizione che deve occupare
            $queryPosizione = "SELECT * FROM geec_categorie WHERE tipo LIKE '$this->tipo' AND categoriaMadre=$this->categoriaMadre ORDER BY posizione DESC LIMIT 1";
            $risQuery = $this->db->eseguiQueryLettura($queryPosizione);
            if($risQuery->num_rows>0) {
                $datiCategoria = $risQuery->fetch_assoc();
                $posizioneCategoriaDuplicata = $datiCategoria["posizione"]+1;
            }
            else {            
                $posizioneCategoriaDuplicata = 1;
            }
            
            $this->db->eseguiQueryScrittura("CREATE TEMPORARY TABLE tabella_temporanea SELECT * FROM geec_categorie WHERE id={$this->id}");
            $this->db->eseguiQueryScrittura("UPDATE tabella_temporanea SET id = 0;");
            $this->db->eseguiQueryScrittura("INSERT INTO geec_categorie SELECT * FROM tabella_temporanea;");
            $idCategoriaDuplicata = $this->db->idUltimoElemento();
            $this->db->eseguiQueryScrittura("DROP TABLE tabella_temporanea");

            $nuovoAlias = generaAlias($this->db,$prefisso.$categoriaDaCopiare["nome"],"geec_categorie","nome");
            $this->db->eseguiQueryScrittura("UPDATE geec_categorie SET nome = CONCAT('$prefisso', ' ', nome), alias='$nuovoAlias', posizione=$posizioneCategoriaDuplicata WHERE id = $idCategoriaDuplicata");
            
            // duplico i componenti
            $query = "SELECT cp.*, c.tipo, c.tabellaRiferimento FROM geecB_composizionePagine AS cp JOIN geecB_componenti AS c ON cp.idComponente = c.id WHERE cp.idPagina={$this->id} AND (cp.tipoElemento LIKE 'categoriaSopraArticoli' OR cp.tipoElemento LIKE 'categoriaSottoArticoli') ORDER BY posizione ASC";
            $result = $this->db->eseguiQueryLettura($query);
            while($componente = $result->fetch_array()) {
                $this->duplicaComponente($componente["id"], $idCategoriaDuplicata);
            }
            
            return $idCategoriaDuplicata;
        }
        
        function traduci($lingua) {
            $idCategoriaTradotto = $this->duplica("Traduzione in $lingua di",$lingua);
            $this->db->eseguiQueryScrittura("UPDATE geec_categorie SET categoriaRiferimento='$this->id', lingua='$lingua' WHERE id=$idCategoriaTradotto");
            return $idCategoriaTradotto;
        }
        
        function caricaDatiDalDatabase() {
            $datiCategoria        = $this->db->leggiSingolaRiga("geec_categorie",$this->id);
            $this->datiCategoria  = $datiCategoria;
            $this->categoriaMadre = $datiCategoria["categoriaMadre"];
            $this->categoriaRiferimento = $datiCategoria["categoriaRiferimento"];
            $this->tipo           = $datiCategoria["tipo"];
            $this->lingua         = $datiCategoria["lingua"];
            $this->nome           = $datiCategoria["nome"];
            $this->titoloPagina   = $datiCategoria["titoloPagina"];
            $this->alias          = $datiCategoria["alias"];
            $this->metaDescrizione= $datiCategoria["metaDescrizione"];
            $this->cssGenerato    = $datiCategoria["cssGenerato"];
            $this->cssAggiuntivo  = $datiCategoria["cssAggiuntivo"];
            $this->foto           = $datiCategoria["foto"];
            $this->elementiPerPagina   = $datiCategoria["numeroArticoliPerPagina"];
            $this->ordinamento         = $datiCategoria["ordinamento"];
            $this->tipoVisualizzazione = $datiCategoria["tipoVisualizzazione"];
        }
        
        function duplicaComponente($idComponente,$idContenuto=0) {
            $queryUtimaSezione  = "SELECT * FROM geecB_composizionePagine ORDER BY id DESC";
            $risSezione         = $this->db->eseguiQueryLettura($queryUtimaSezione);
            $ultimaSezione      = $risSezione->fetch_assoc();
            $progressivoSezione = $ultimaSezione["id"] +1;
            $idSezione  = "sezione$progressivoSezione";
            
            /*
             * Il campo opzionale $idContenuto ha valore diverso da 0 solo quando viene effettuata una duplicazione, in tal caso
             * bisogna considerare le tabelle del contenuto duplicato e non di quell obase
             */
            $idContenutoElementoDuplicato = ($idContenuto!=0) ? $idContenuto : $this->id;
                    
            $query    = "SELECT cp.*, c.nome AS nomeComponente, c.tipo, c.tabellaRiferimento FROM geecB_composizionePagine AS cp JOIN geecB_componenti AS c ON cp.idComponente = c.id WHERE cp.id={$idComponente}";
            $risQuery = $this->db->eseguiQueryLettura($query);
            $componente = $risQuery->fetch_assoc();
            
            $testo          = filter_var($componente["testo"],FILTER_SANITIZE_ADD_SLASHES);
            $codiceGenerato = filter_var($componente["codiceGenerato"],FILTER_SANITIZE_ADD_SLASHES);
            $script         = filter_var($componente["script"],FILTER_SANITIZE_ADD_SLASHES);
            
            if($componente["tipo"]=="componenteDinamicoPagine" || $componente["tipo"]=="componenteStrutturaPagina") {
                $this->db->eseguiQueryScrittura("CREATE TEMPORARY TABLE tabella_temporaneaComponente SELECT * FROM {$componente["tabellaRiferimento"]} WHERE id={$componente["idElemento"]}");
                $this->db->eseguiQueryScrittura("UPDATE tabella_temporaneaComponente SET id = 0;");
                $this->db->eseguiQueryScrittura("INSERT INTO {$componente["tabellaRiferimento"]} SELECT * FROM tabella_temporaneaComponente;");
                $idElemento = $this->db->idUltimoElemento();
                $this->db->eseguiQueryScrittura("DROP TABLE tabella_temporaneaComponente");
                $this->duplicaElementiComponente($componente,$idElemento,$idContenuto);
                
                $queryAggiornamentoNomeComponente = "UPDATE {$componente["tabellaRiferimento"]} SET nome = CONCAT('Copia di',' ',nome) WHERE id=$idElemento";
                $this->db->eseguiQueryCreazione($queryAggiornamentoNomeComponente);
                
                $queryInserimentoComponente = "INSERT INTO geecB_composizionePagine VALUES(NULL,{$componente["idComponente"]},$idContenutoElementoDuplicato,'{$componente["tipoElemento"]}',{$idElemento},{$componente["posizione"]},'$testo','$codiceGenerato','$script','{$componente["nascosto"]}','$idSezione','{$componente["classeSezione"]}','{$componente["aTuttaLarghezza"]}','{$componente["margineSezione"]}','{$componente["paddingSezione"]}','{$componente["animazione"]}','{$componente["coloreSfondo"]}','{$componente["immagineSfondo"]}','{$componente["videoSfondo"]}','{$componente["altreOpzioni"]}')";
            }
            else if($componente["nomeComponente"]=="Singola risorsa") {
                $fileScaricabile    = new FileScaricabile($this->getDb(), $componente["idElemento"]);
                $idRisorsaDuplicata = $fileScaricabile->duplica();
                $altreOpzioni = filter_var(str_replace("nomeRisorsa=","nomeRisorsa=Copia di ",$componente["altreOpzioni"]),FILTER_SANITIZE_ADD_SLASHES);
                $queryInserimentoComponente = "INSERT INTO geecB_composizionePagine VALUES(NULL,{$componente["idComponente"]},$idContenutoElementoDuplicato,'{$componente["tipoElemento"]}','{$idRisorsaDuplicata}',{$componente["posizione"]},'$testo','$codiceGenerato','$script','{$componente["nascosto"]}','{$idSezione}','{$componente["classeSezione"]}','{$componente["aTuttaLarghezza"]}','{$componente["margineSezione"]}','{$componente["paddingSezione"]}','{$componente["animazione"]}','{$componente["coloreSfondo"]}','{$componente["immagineSfondo"]}','{$componente["videoSfondo"]}','$altreOpzioni')";
            }
            else {
                $queryInserimentoComponente = "INSERT INTO geecB_composizionePagine VALUES(NULL,{$componente["idComponente"]},$idContenutoElementoDuplicato,'{$componente["tipoElemento"]}',{$componente["idElemento"]},{$componente["posizione"]},'$testo','$codiceGenerato','$script','{$componente["nascosto"]}','{$idSezione}','{$componente["classeSezione"]}','{$componente["aTuttaLarghezza"]}','{$componente["margineSezione"]}','{$componente["paddingSezione"]}','{$componente["animazione"]}','{$componente["coloreSfondo"]}','{$componente["immagineSfondo"]}','{$componente["videoSfondo"]}','{$componente["altreOpzioni"]}')";
            }
            $idNuovoComponente = $this->db->eseguiQueryCreazione($queryInserimentoComponente);
            
            $posizioneNuovoComponente = $componente["posizione"] +1;
            $this->modificaPosizioneComponente($idNuovoComponente,$posizioneNuovoComponente,$idContenuto);
            return $idNuovoComponente;
        }
        
        /*
         * Questo metodo serve per duplicare gli elementi all'interno del componente, esempio gli elementi di un form,
         * le slide di uno slider e cosi via.
         * 
         * Usato anche per le sezioni multiple (due, tre e quattro colonne) dove va a ricreare i componenti ad essa collegata
         * 
         * @param $componente: dati del componente di partenza
         * @param $idElemento: id dell'occorrenza creata
         * 
         * Il campo opzionale $idContenuto ha valore diverso da 0 solo quando viene effettuata una duplicazione, in tal caso
         * bisogna considerare le tabelle del contenuto duplicato e non il campo $this-id
         */
        function duplicaElementiComponente($componente,$idElemento,$idContenuto=0) {
            if($componente["nomeComponente"]=="Sezione a due colonne") {
                $datiSezioneADueColonne = $this->db->leggiSingolaRiga("geec_sezioniADueColonne",$componente["idElemento"]);
                $idComponente1 = ($datiSezioneADueColonne["idComponenteSezione1"]!=0) ? $this->duplicaComponente($datiSezioneADueColonne["idComponenteSezione1"],$idContenuto) : 0;
                $idComponente2 = ($datiSezioneADueColonne["idComponenteSezione2"]!=0) ? $this->duplicaComponente($datiSezioneADueColonne["idComponenteSezione2"],$idContenuto) : 0;
                
                $queryAggiornamentoSezione = "UPDATE geec_sezioniADueColonne SET idComponenteSezione1=$idComponente1, idComponenteSezione2=$idComponente2 WHERE id=$idElemento";
                $this->db->eseguiQueryScrittura($queryAggiornamentoSezione);
            }
            else if($componente["nomeComponente"]=="Sezione a tre colonne") {
                $datiSezioneATreColonne = $this->db->leggiSingolaRiga("geec_sezioniATreColonne",$componente["idElemento"]);
                $idComponente1 = ($datiSezioneATreColonne["idComponenteSezione1"]!=0) ? $this->duplicaComponente($datiSezioneATreColonne["idComponenteSezione1"],$idContenuto) : 0;
                $idComponente2 = ($datiSezioneATreColonne["idComponenteSezione2"]!=0) ? $this->duplicaComponente($datiSezioneATreColonne["idComponenteSezione2"],$idContenuto) : 0;
                $idComponente3 = ($datiSezioneATreColonne["idComponenteSezione3"]!=0) ? $this->duplicaComponente($datiSezioneATreColonne["idComponenteSezione3"],$idContenuto) : 0;
                                
                $queryAggiornamentoSezione = "UPDATE geec_sezioniATreColonne SET idComponenteSezione1=$idComponente1, idComponenteSezione2=$idComponente2, idComponenteSezione3=$idComponente3 WHERE id=$idElemento";
                $this->db->eseguiQueryScrittura($queryAggiornamentoSezione);
            }
            else if($componente["nomeComponente"]=="Sezione a quattro colonne") {
                $datiSezioneAQuattroColonne = $this->db->leggiSingolaRiga("geec_sezioniAQuattroColonne",$componente["idElemento"]);
                $idComponente1 = ($datiSezioneAQuattroColonne["idComponenteSezione1"]!=0) ? $this->duplicaComponente($datiSezioneAQuattroColonne["idComponenteSezione1"],$idContenuto) : 0;
                $idComponente2 = ($datiSezioneAQuattroColonne["idComponenteSezione2"]!=0) ? $this->duplicaComponente($datiSezioneAQuattroColonne["idComponenteSezione2"],$idContenuto) : 0;
                $idComponente3 = ($datiSezioneAQuattroColonne["idComponenteSezione3"]!=0) ? $this->duplicaComponente($datiSezioneAQuattroColonne["idComponenteSezione3"],$idContenuto) : 0;
                $idComponente4 = ($datiSezioneAQuattroColonne["idComponenteSezione4"]!=0) ? $this->duplicaComponente($datiSezioneAQuattroColonne["idComponenteSezione4"],$idContenuto) : 0;
                
                $queryAggiornamentoSezione = "UPDATE geec_sezioniAQuattroColonne SET idComponenteSezione1=$idComponente1, idComponenteSezione2=$idComponente2, idComponenteSezione3=$idComponente3, idComponenteSezione4=$idComponente4 WHERE id=$idElemento";
                $this->db->eseguiQueryScrittura($queryAggiornamentoSezione);
            }
            else if($componente["nomeComponente"]=="Portfolio") {
                $query       = "SELECT * FROM geecB_contenuti WHERE contenutoRiferimento='{$componente["idElemento"]}'";
                $risElementi = $this->db->eseguiQueryLettura($query);
                while($elementoDaCopiare = $risElementi->fetch_assoc()) {
                    $idContenutoDuplicato = $this->copiaTabellaElemento("geecB_contenuti",$elementoDaCopiare["id"]);
                    $this->db->eseguiQueryScrittura("UPDATE geecB_contenuti SET alias='copia-di-{$elementoDaCopiare["alias"]}', contenutoRiferimento=$idElemento, numeroVisite=0 WHERE id=$idContenutoDuplicato");
                }
            }
            else if($componente["nomeComponente"]=="Slider") {
                $query       = "SELECT * FROM geec_slide WHERE idSlider='{$componente["idElemento"]}'";
                $risElementi = $this->db->eseguiQueryLettura($query);
                while($elementoDaCopiare = $risElementi->fetch_assoc()) {
                    $idContenutoDuplicato = $this->copiaTabellaElemento("geec_slide",$elementoDaCopiare["id"]);
                    $this->db->eseguiQueryScrittura("UPDATE geec_slide SET idSlider=$idElemento, numeroClick=0 WHERE id=$idContenutoDuplicato");
                }
            }
            else if($componente["nomeComponente"]=="Griglia contenuti") {
                $query       = "SELECT * FROM geec_immaginiGriglia WHERE idGriglia='{$componente["idElemento"]}'";
                $risElementi = $this->db->eseguiQueryLettura($query);
                while($elementoDaCopiare = $risElementi->fetch_assoc()) {
                    $idContenutoDuplicato = $this->copiaTabellaElemento("geec_immaginiGriglia",$elementoDaCopiare["id"]);
                    $this->db->eseguiQueryScrittura("UPDATE geec_immaginiGriglia SET idGriglia=$idElemento WHERE id=$idContenutoDuplicato");
                }
            }
            else if($componente["nomeComponente"]=="Form") {
                $query       = "SELECT * FROM geec_elementiForm WHERE idForm='{$componente["idElemento"]}'";
                $risElementi = $this->db->eseguiQueryLettura($query);
                while($elementoDaCopiare = $risElementi->fetch_assoc()) {
                    $idContenutoDuplicato = $this->copiaTabellaElemento("geec_elementiForm",$elementoDaCopiare["id"]);
                    $this->db->eseguiQueryScrittura("UPDATE geec_elementiForm SET idForm=$idElemento WHERE id=$idContenutoDuplicato");
                }
            }
            else if($componente["nomeComponente"]=="Lista") {
                $query       = "SELECT * FROM geec_elementiLista WHERE idLista='{$componente["idElemento"]}'";
                $risElementi = $this->db->eseguiQueryLettura($query);
                while($elementoDaCopiare = $risElementi->fetch_assoc()) {
                    $idContenutoDuplicato = $this->copiaTabellaElemento("geec_elementiLista",$elementoDaCopiare["id"]);
                    $this->db->eseguiQueryScrittura("UPDATE geec_elementiLista SET idLista=$idElemento WHERE id=$idContenutoDuplicato");
                }
            }
            else if($componente["nomeComponente"]=="Contatore") {
                $query       = "SELECT * FROM geec_elementiContatore WHERE idContatore='{$componente["idElemento"]}'";
                $risElementi = $this->db->eseguiQueryLettura($query);
                while($elementoDaCopiare = $risElementi->fetch_assoc()) {
                    $idContenutoDuplicato = $this->copiaTabellaElemento("geec_elementiContatore",$elementoDaCopiare["id"]);
                    $this->db->eseguiQueryScrittura("UPDATE geec_elementiContatore SET idContatore=$idElemento WHERE id=$idContenutoDuplicato");
                }
            }
        }
        
        function modificaPosizioneComponente($idComponente,$posizione,$idContenuto=0) {
            if($this->tipo=="pagina" || $this->tipo=="articolo" || $this->tipo=="pagina") {            
                $tipoElemento  = "contenuto";
            }
            else {
                $tipoElemento = $this->tipo;
            }
            
            /*
             * Il campo opzionale $idContenuto ha valore diverso da 0 solo quando viene effettuata una duplicazione, in tal caso
             * bisogna considerare le tabelle del contenuto duplicato e non di quell obase
             */
            $idContenutoDaCercare = ($idContenuto!=0) ? $idContenuto : $this->id;
            
            // le occorrenze di geecB_composizionePagine prese in considerazione sono solo quelle di tipo contenuto (devono essere escluse quelle delle sezioni multiple)
            $queryPosizione = "SELECT * FROM geecB_composizionePagine WHERE idPagina=$idContenutoDaCercare AND tipoElemento LIKE '$tipoElemento' AND id != $idComponente ORDER BY posizione ASC";
            $risElementi    = $this->db->eseguiQueryLettura($queryPosizione);
            
            $posizioneCorrente = 1;
            while($elementoCorrente = $risElementi->fetch_assoc()) {
                if($posizione==$posizioneCorrente) {
                    $posizioneCorrente++;
                }
                $queryPosizione = "UPDATE geecB_composizionePagine SET posizione=$posizioneCorrente WHERE id = {$elementoCorrente["id"]} ";
                $this->db->eseguiQueryScrittura($queryPosizione);
                $posizioneCorrente ++;
            }
            $queryPosizioneElementoPrincipale = "UPDATE geecB_composizionePagine SET posizione=$posizione WHERE id = $idComponente ";
            $this->db->eseguiQueryScrittura($queryPosizioneElementoPrincipale);
        }
        
        function cssGenerato() {
            $queryPosizione = "SELECT * FROM geecB_composizionePagine WHERE idPagina=$this->id AND (tipoElemento LIKE 'categoriaSopraArticoli' OR tipoElemento LIKE 'categoriaSottoArticoli') ORDER BY posizione ASC";
            $risComponenti  = $this->db->eseguiQueryLettura($queryPosizione);
            
            $cssGenerato = "";
            while($componente = $risComponenti->fetch_assoc()) {
                $cssGeneratoSezione = "";
                if($componente["margineSezione"]!="" || $componente["paddingSezione"]!="") {
                    $stringaMargine = ($componente["margineSezione"]!="") ? "margin:{$componente["margineSezione"]};" : "";
                    $stringaPadding = ($componente["paddingSezione"]!="") ? "padding:{$componente["paddingSezione"]};" : "";
                    $cssGeneratoSezione = "
                    #{$componente["idSezione"]} {
                        $stringaMargine
                        $stringaPadding
                    }
                    ";
                }
                $cssGenerato.= $cssGeneratoSezione;
            }
            return $cssGenerato;
        }
        
        function aggiornaCssGenerato() {
            $cssGenerato = $this->cssGenerato();
            
            $queryPosizioneElementoPrincipale = "UPDATE geec_categorie SET cssGenerato='$cssGenerato' WHERE id = $this->id ";
            $this->db->eseguiQueryScrittura($queryPosizioneElementoPrincipale);
        }
        
        /*
         * Stampa i componenti visualizzati prima del blocco di articoli
         */
        function stampaComponentiContenuto($tipoElemento,$percorsoBase = "") {
            
            $datiGeecomCMS = $this->db->leggiSingolaRiga("geec_prodotti",1);
            $impostazioni  = recuperaImpostazioni($this->db);
            $linkBaseAreaAmministrativaCMS = $impostazioni["urlSito"]."/".str_replace("../","",$datiGeecomCMS["percorso"]);
            
            $queryComponentiDaMostrare = "SELECT c.id, c.idSezione, c.idElemento, c.nascosto, c.classeSezione, c.testo, cm.nome, cm.tipo, cm.icona, cm.paginaGestione, cm.tabellaRiferimento, c.posizione, c.margineSezione, c.paddingSezione, c.aTuttaLarghezza, c.coloreSfondo, c.immagineSfondo, c.videoSfondo FROM geecB_composizionePagine AS c JOIN geecB_componenti AS cm ON c.idComponente=cm.id WHERE c.idPagina = {$this->getId()} AND tipoElemento LIKE '$tipoElemento'  ORDER BY c.posizione ASC";
            $risComponenti = $this->db->eseguiQueryLettura($queryComponentiDaMostrare);

            // se nella pagina ci sono più di 7 componenti viene inserito anche un pulsante in 
            // alto per non costringere l'utente ad arrivare in fondo alla pagina
            if($risComponenti->num_rows>7) {
        ?>
                <button type="button" class="btn btn-success btn-block mb-3" data-toggle="modal" data-target="#aggiungi-componente"><i class="fas fa-plus"></i> Aggiungi un componente</button>
        <?php
            }
            if($risComponenti->num_rows==0) {

            }
            else {

                while($componente = $risComponenti->fetch_assoc()) {
                    if($componente["tipo"]=="componenteDinamico" || $componente["tipo"]=="componenteDinamicoNonConfigurabile" || $componente["tipo"]=="pagine") {
                        $nomeElemento = "";
                    }
                    else {
                        $elemento = $this->db->leggiSingolaRiga($componente["tabellaRiferimento"],$componente["idElemento"]);
                        $nomeElemento = filter_var($elemento["nome"],FILTER_SANITIZE_ADD_SLASHES);
                    }

                    if($componente["tipo"]!="componenteDinamico") {
                        $linkModificaComponente = creaLinkModifica($componente,$linkBaseAreaAmministrativaCMS);
                        $stringaPulsanteModifica = "onclick=\"{location.href='$linkModificaComponente';}\"";
                    }
                    else {
                        $stringaPulsanteModifica = "onclick=\"apriModalModificaComponenteContenuto('../',{$componente["id"]})";
                    }

                    $posizionePrecedente = $componente["posizione"]-1;
                    $posizioneSuccessiva = $componente["posizione"]+1;
                    $nomeComponente      = filter_var($componente["nome"],FILTER_SANITIZE_ADD_SLASHES);
                    $classeComponenteAttivato = ($componente["nascosto"]=="si") ? "nascostoSuFront" : "";
                    
                    echo"<div id=\"componenteContenuto{$componente["id"]}\" class=\"card mb-3 $classeComponenteAttivato\">
                        <div class=\"card-header py-1 pr-sm-1 d-sm-flex justify-content-between align-items-center text-center\">
                            <div class=\"mb-1 mb-sm-0 d-flex align-items-center justify-content-start\">
                                <small class=\"text-muted mr-3\"><em><strong>ID:</strong></em> {$componente["idSezione"]} </small>
                                <small class=\"text-muted\"><em><strong>Classi:</strong></em> {$componente["classeSezione"]} </small>
                            </div>
                            <div class=\"azioni d-flex align-items-center justify-content-end\">
                                <form class=\"d-inline-flex mr-sm-1\">
                                    <div class=\"input-group input-group-sm d-flex align-items-center\">
                                        <small class=\"text-muted mr-2\">Pos.</small>
                                        <input type=\"number\" class=\"form-control\" aria-label=\"posizione\" min=\"1\" value=\"{$componente["posizione"]}\" id=\"posizioneComponente{$componente["id"]}\">
                                        <div class=\"input-group-append\">
                                            <button class=\"btn btn-primary\" type=\"button\" onclick=\"modificaPosizioneComponenteContenutoDaInput($this->id},{$componente["id"]},'$tipoElemento')\">Salva</button>
                                        </div>
                                    </div>
                                </form>
                                <div class=\"btn-group\" role=\"group\" aria-label=\"Basic example\">
                                    <button type=\"button\" class=\"btn btn-light modifica\" data-toggle=\"tooltip\" data-placement=\"bottom\" title=\"Sposta su\" onclick={modificaPosizioneComponenteContenuto({$this->id},{$componente["id"]},'$tipoElemento',$posizionePrecedente);}><i class=\"fas fa-arrow-up\" ></i></button>
                                    <button type=\"button\" class=\"btn btn-light modifica\" data-toggle=\"tooltip\" data-placement=\"bottom\" title=\"Sposta giu\" onclick={modificaPosizioneComponenteContenuto({$this->id},{$componente["id"]},'$tipoElemento',$posizioneSuccessiva);}><i class=\"fas fa-arrow-down\"></i></button>
                                    <button type=\"button\" class=\"btn btn-light modifica\" data-toggle=\"tooltip\" data-placement=\"bottom\" title=\"Configura\" onclick=\"modificaImpostazioniSezione({$componente["id"]},'{$componente["idSezione"]}','{$componente["classeSezione"]}','{$componente["aTuttaLarghezza"]}','{$componente["margineSezione"]}','{$componente["paddingSezione"]}','{$componente["coloreSfondo"]}','{$componente["immagineSfondo"]}','{$componente["videoSfondo"]}')\"><i class=\"fas fa-cog\"></i></button>
                                    <button type=\"button\" class=\"btn btn-light modifica\" data-toggle=\"tooltip\" data-placement=\"bottom\" title=\"Duplica\" onclick=\"duplicaComponente({$componente["id"]})\"><i class=\"far fa-clone\"></i></button>";
                                    if($componente["nascosto"]=="si") {
                                        echo"<button type=\"button\" class=\"btn btn-light modifica\" data-toggle=\"tooltip\" data-placement=\"bottom\" title=\"Mostra\" onclick=\"invertiValoreComponenteNascosto({$componente["id"]})\"><i id=\"iconaInvertiValoreNascosto{$componente["id"]}\" class=\"far fa-eye\"></i></button>";
                                    }
                                    else {
                                        echo"<button type=\"button\" class=\"btn btn-light modifica\" data-toggle=\"tooltip\" data-placement=\"bottom\" title=\"Nascondi\" onclick=\"invertiValoreComponenteNascosto({$componente["id"]})\"><i id=\"iconaInvertiValoreNascosto{$componente["id"]}\" class=\"far fa-eye-slash\"></i></button>";
                                    }
                                    echo"<button type=\"button\" class=\"btn btn-light elimina\" data-toggle=\"tooltip\" data-placement=\"bottom\" title=\"Elimina\" onclick=\"eliminaComponenteContenuto({$componente["id"]},'{$componente["icona"]}','$nomeComponente','$nomeElemento')\" ><i class=\"far fa-trash-alt\"></i></button>
                                </div>
                           </div>
                        </div>";
                        
                        if($componente["nome"]=="Sezione a due colonne") {
                            $datiSezioneDoppia = $this->db->leggiSingolaRiga("geec_sezioniADueColonne",$componente["idElemento"]);
                            $classiDiv = explode(", ", $datiSezioneDoppia["proporzioni"]);
                        ?>
                        <div class= "card-body">
                            <div class="form-row align-items-center">
                                <div class="col-12 col-md-auto mb-2 mb-md-0 d-flex align-items-center">
                                    <label class="mr-2 align-self-center mb-0 text-nowrap" for="inputPassword3" >Proporzioni</label>
                                    <select class="form-control" id="proporzioniSezione<?php echo $componente["idElemento"] ?>" onChange="aggiornaDivSezioneMultipla(<?php echo $componente["idElemento"] ?>)" >
                                    <?php 
                                        $arrayProporzioni = array("col-md-6, col-md-6"=>"1/2 - 1/2",
                                            "col-md-4, col-md-8"=>"1/3 - 2/3",
                                            "col-md-3, col-md-9"=>"1/4 - 3/4",
                                            "col-md-2, col-md-10"=>"1/6 - 5/6",
                                            "col-md-8, col-md-4"=>  "2/3 - 1/3",
                                            "col-md-9, col-md-3"=>  "3/4 - 1/4",
                                            "col-md-10, col-md-2"=>  "5/6 - 1/6"
                                        );
                                        foreach($arrayProporzioni as $classe=>$descrizione) {
                                            if($datiSezioneDoppia["proporzioni"]==$classe) {
                                                echo"<option value=\"$classe\" selected>$descrizione</option>";
                                            }
                                            else {
                                                echo"<option value=\"$classe\">$descrizione</option>";
                                            }
                                        }
                                    ?>
                                    </select>
                                </div>

                                <div class="col-12 col-md-auto mb-2 mb-md-0 d-flex align-items-center">
                                    <label class="mr-2 align-self-center mb-0 text-nowrap" for="">Allineamento <span class="d-none d-sm-inline-block">contenuti</span></label>
                                    <select class="form-control" id="allineamentoSezione<?php echo $componente["idElemento"] ?>">
                                        <?php 
                                        $arrayAllineamenti = array("d-flex align-items-start"=>"In alto",
                                            "d-flex align-items-center"=>"Al centro",
                                            "d-flex align-items-end"=>"In basso",
                                            "d-flex align-items-baseline"=>"Linea base",
                                            "d-flex align-items-stretch"=>  "Stretch"
                                        );
                                        foreach($arrayAllineamenti as $classe=>$descrizione) {
                                            if($datiSezioneDoppia["allineamento"]==$classe) {
                                                echo"<option value=\"$classe\" selected>$descrizione</option>";
                                            }
                                            else {
                                                echo"<option value=\"$classe\">$descrizione</option>";
                                            }
                                        }
                                    ?>
                                    </select>
                                </div>
                                <div class="col">
                                    <button type="button" onclick="salvaDatiSezioneMultipla(<?php echo $componente["idElemento"] ?>,'geec_sezioniADueColonne')" class="btn btn-primary float-right float-md-left">Salva<i class="fas fa-check fa-fw ml-1"></i></button>
                                </div>
                            </div>
                            <hr>

                            <div class="form-row">
                                <div id="div1SezioneMultipla<?php echo $componente["idElemento"] ?>" class="<?php echo $classiDiv[0] ?> d-flex align-items-stretch">
                                    <?php $this->stampaComponenteSezioneMultipla($datiSezioneDoppia,1,$linkBaseAreaAmministrativaCMS,'geec_sezioniADueColonne'); ?>
                                </div>
                                <div id="div2SezioneMultipla<?php echo $componente["idElemento"] ?>" class="<?php echo $classiDiv[1] ?> d-flex align-items-stretch">
                                    <?php $this->stampaComponenteSezioneMultipla($datiSezioneDoppia,2,$linkBaseAreaAmministrativaCMS,'geec_sezioniADueColonne'); ?>
                                </div>
                            </div>
                        </div>
                    <?php            
                        }
                        else if($componente["nome"]=="Sezione a tre colonne") {
                            $datiSezioneTripla = $this->db->leggiSingolaRiga("geec_sezioniATreColonne",$componente["idElemento"]);
                            $classiDiv = explode(", ", $datiSezioneTripla["proporzioni"]);
                        ?>
                        <div class= "card-body">
                            <div class="form-row align-items-center">
                                <div class="col-12 col-md-auto mb-2 mb-md-0 d-flex align-items-center">
                                    <label class="mr-2 align-self-center mb-0 text-nowrap" for="inputPassword3" >Proporzioni</label>
                                    <select class="form-control" id="proporzioniSezione<?php echo $componente["idElemento"] ?>" onChange="aggiornaDivSezioneMultipla(<?php echo $componente["idElemento"] ?>)" >
                                    <?php 
                                        $arrayProporzioni = array("col-md-4, col-md-4, col-md-4"=>"1/3 - 1/3 - 1/3",
                                            "col-md-6, col-md-3, col-md-3"=>"1/2 - 1/4 - 1/4",
                                            "col-md-3, col-md-6, col-md-3"=>"1/4 - 1/2 - 1/4",
                                            "col-md-3, col-md-3, col-md-6"=>"1/4 - 1/4 - 1/2"
                                        );
                                        foreach($arrayProporzioni as $classe=>$descrizione) {
                                            if($datiSezioneTripla["proporzioni"]==$classe) {
                                                echo"<option value=\"$classe\" selected>$descrizione</option>";
                                            }
                                            else {
                                                echo"<option value=\"$classe\">$descrizione</option>";
                                            }
                                        }
                                    ?>
                                    </select>
                                </div>

                                <div class="col-12 col-md-auto mb-2 mb-md-0 d-flex align-items-center">
                                    <label class="mr-2 align-self-center mb-0 text-nowrap" for="">Allineamento <span class="d-none d-sm-inline-block">contenuti</span></label>
                                    <select class="form-control" id="allineamentoSezione<?php echo $componente["idElemento"] ?>">
                                        <?php 
                                        $arrayAllineamenti = array("d-flex align-items-start"=>"In alto",
                                            "d-flex align-items-center"=>"Al centro",
                                            "d-flex align-items-end"=>"In basso",
                                            "d-flex align-items-baseline"=>"Linea base",
                                            "d-flex align-items-stretch"=>  "Stretch"
                                        );
                                        foreach($arrayAllineamenti as $classe=>$descrizione) {
                                            if($datiSezioneTripla["allineamento"]==$classe) {
                                                echo"<option value=\"$classe\" selected>$descrizione</option>";
                                            }
                                            else {
                                                echo"<option value=\"$classe\">$descrizione</option>";
                                            }
                                        }
                                    ?>
                                    </select>
                                </div>
                                <div class="col">
                                    <button type="button" onclick="salvaDatiSezioneMultipla(<?php echo $componente["idElemento"] ?>,'geec_sezioniATreColonne')" class="btn btn-primary float-right float-md-left">Salva<i class="fas fa-check fa-fw ml-1"></i></button>
                                </div>
                            </div>
                            <hr>

                            <div class="form-row">
                                <div id="div1SezioneMultipla<?php echo $componente["idElemento"] ?>" class="<?php echo $classiDiv[0] ?> d-flex align-items-stretch">
                                    <?php $this->stampaComponenteSezioneMultipla($datiSezioneTripla,1,$linkBaseAreaAmministrativaCMS,'geec_sezioniATreColonne'); ?>
                                </div>
                                <div id="div2SezioneMultipla<?php echo $componente["idElemento"] ?>" class="<?php echo $classiDiv[1] ?> d-flex align-items-stretch">
                                    <?php $this->stampaComponenteSezioneMultipla($datiSezioneTripla,2,$linkBaseAreaAmministrativaCMS,'geec_sezioniATreColonne'); ?>
                                </div>
                                <div id="div3SezioneMultipla<?php echo $componente["idElemento"] ?>" class="<?php echo $classiDiv[2] ?> d-flex align-items-stretch">
                                    <?php $this->stampaComponenteSezioneMultipla($datiSezioneTripla,3,$linkBaseAreaAmministrativaCMS,'geec_sezioniATreColonne'); ?>
                                </div>
                            </div>
                        </div>
                    <?php            
                        }
                        else if($componente["nome"]=="Sezione a quattro colonne") {
                            $datiSezioneQuadrupla = $this->db->leggiSingolaRiga("geec_sezioniAQuattroColonne",$componente["idElemento"]);
                        ?>
                        <div class= "card-body">
                            <div class="form-row align-items-center">                                
                                <div class="col-12 col-md-auto mb-2 mb-md-0 d-flex align-items-center">
                                    <label class="mr-2 align-self-center mb-0 text-nowrap" for="">Allineamento <span class="d-none d-sm-inline-block">contenuti</span></label>
                                    <select class="form-control" id="allineamentoSezione<?php echo $componente["idElemento"] ?>">
                                        <?php 
                                        $arrayAllineamenti = array("d-flex align-items-start"=>"In alto",
                                            "d-flex align-items-center"=>"Al centro",
                                            "d-flex align-items-end"=>"In basso",
                                            "d-flex align-items-baseline"=>"Linea base",
                                            "d-flex align-items-stretch"=>  "Stretch"
                                        );
                                        foreach($arrayAllineamenti as $classe=>$descrizione) {
                                            if($datiSezioneQuadrupla["allineamento"]==$classe) {
                                                echo"<option value=\"$classe\" selected>$descrizione</option>";
                                            }
                                            else {
                                                echo"<option value=\"$classe\">$descrizione</option>";
                                            }
                                        }
                                    ?>
                                    </select>
                                </div>
                                <div class="col">
                                    <button type="button" onclick="salvaDatiSezioneMultipla(<?php echo $componente["idElemento"] ?>,'geec_sezioniAQuattroColonne')" class="btn btn-primary float-right float-md-left">Salva<i class="fas fa-check fa-fw ml-1"></i></button>
                                </div>
                            </div>
                            <hr>

                            <div class="form-row">
                                <div id="div1SezioneMultipla<?php echo $componente["idElemento"] ?>" class="col-md-3 d-flex align-items-stretch">
                                    <?php $this->stampaComponenteSezioneMultipla($datiSezioneQuadrupla,1,$linkBaseAreaAmministrativaCMS,'geec_sezioniAQuattroColonne'); ?>
                                </div>
                                <div id="div2SezioneMultipla<?php echo $componente["idElemento"] ?>" class="col-md-3 d-flex align-items-stretch">
                                    <?php $this->stampaComponenteSezioneMultipla($datiSezioneQuadrupla,2,$linkBaseAreaAmministrativaCMS,'geec_sezioniAQuattroColonne'); ?>
                                </div>
                                <div id="div3SezioneMultipla<?php echo $componente["idElemento"] ?>" class="col-md-3 d-flex align-items-stretch">
                                    <?php $this->stampaComponenteSezioneMultipla($datiSezioneQuadrupla,3,$linkBaseAreaAmministrativaCMS,'geec_sezioniAQuattroColonne'); ?>
                                </div>
                                <div id="div4SezioneMultipla<?php echo $componente["idElemento"] ?>" class="col-md-3 d-flex align-items-stretch">
                                    <?php $this->stampaComponenteSezioneMultipla($datiSezioneQuadrupla,4,$linkBaseAreaAmministrativaCMS,'geec_sezioniAQuattroColonne'); ?>
                                </div>
                            </div>
                        </div>
                    <?php            
                        }
                        else {
                            echo"<div class= \"card-body py-lg-0 d-flex align-items-center\">
                                <img class=\"thumb d-none d-lg-block\" src=\"$percorsoBase{$componente["icona"]}\">
                                <span class=\"mr-3 align-self-center text-primary\"><em>{$componente["nome"]}</em></span>
                                <div class=\"input-group mr-3\">";
                                    if($componente["tipo"]=="componenteDinamicoPagine") {
                                        $queryElementiComponente = "SELECT * FROM {$componente["tabellaRiferimento"]}";
                                        $risElementoComponente   = $this->db->eseguiQueryLettura($queryElementiComponente);
                                        echo"<select class=\"form-control form-control-sm\" id=\"idElementoComponente{$componente["id"]}\">";
                                                while($elemento = $risElementoComponente->fetch_assoc()) {
                                                    if($componente["idElemento"]==$elemento["id"]) {
                                                        echo"<option value=\"{$elemento["id"]}\" selected >{$elemento["nome"]}</option>";
                                                    }
                                                    else {
                                                        echo"<option value=\"{$elemento["id"]}\">{$elemento["nome"]}</option>";
                                                    }
                                                }
                                        echo"</select>
                                        <div class=\"input-group-append\">
                                            <button type=\"button\" class=\"btn btn-primary btn-sm\" onclick=\"cambiaIdElementoComponenteContenuto({$componente["id"]})\">Salva</button>
                                        </div>";
                                    }
                                    else {
                                        echo"<span class=\"text-truncate text-muted d-block w-75\">". substr(strip_tags($componente["testo"]),0,90)."</span>";
                                    }
                                    echo"
                                </div>
                                <div class=\"btn-group\">";
                                    if($componente["tipo"]!="componenteDinamicoNonConfigurabile") {   
                                        echo "<button type=\"button\" class=\"btn btn-primary btn-sm text-nowrap\" $stringaPulsanteModifica \"><span class=\"d-none d-lg-inline-block\">Configura</span><i class=\"far fa-edit fa-fw ml-1\"></i></button>";
                                    }
                                echo"</div>
                            </div>";
                        }
                    echo"</div>";
                }
            }
        }
                
        function copiaTabellaElemento($tabella,$id) {
            $this->db->eseguiQueryScrittura("CREATE TEMPORARY TABLE tabella_temporanea SELECT * FROM $tabella WHERE id=$id");
            $this->db->eseguiQueryScrittura("UPDATE tabella_temporanea SET id = 0;");
            $this->db->eseguiQueryScrittura("INSERT INTO $tabella SELECT * FROM tabella_temporanea;");
            $idContenutoDuplicato = $this->db->idUltimoElemento();
            $this->db->eseguiQueryScrittura("DROP TABLE tabella_temporanea");
            
            return $idContenutoDuplicato;
        }
        
        /*
         * Metodo per stampare il contenuto delle sezioni multiple (a due colonne, tre colonne e quattro colonne)
         */
        function stampaComponenteSezioneMultipla($datiSezione,$posizioneComponente,$linkBaseAreaAmministrativaCMS,$tabellaSezione) {
                $componenteSezione    = $datiSezione["idComponenteSezione$posizioneComponente"];
                $classeDivContenitore = ($componenteSezione!=0) ? "bg-light p-3 w-100" : "bg-light p-3 d-flex align-items-center w-100";
            ?>
            <div class="<?php echo $classeDivContenitore ?>">
                <?php 
                    if($componenteSezione!=0) {

                        $queryComponenteSinistra = "SELECT c.id, c.idSezione, c.idElemento, c.classeSezione, c.aTuttaLarghezza, c.margineSezione, c.paddingSezione, c.testo, cm.nome, cm.tipo, cm.icona, cm.paginaGestione, cm.tabellaRiferimento, c.posizione FROM geecB_composizionePagine AS c JOIN geecB_componenti AS cm ON c.idComponente=cm.id WHERE c.id = {$componenteSezione} ORDER BY c.posizione ASC";
                        $risComponenteSinistra   = $this->db->eseguiQueryLettura($queryComponenteSinistra);
                        $datiComponenteSezione   = $risComponenteSinistra->fetch_assoc();
                        $nomeComponenteSezione   = filter_var($datiComponenteSezione["nome"],FILTER_SANITIZE_ADD_SLASHES);
                        if($datiComponenteSezione["tipo"]=="componenteDinamico") {
                            $nomeElemento = "";
                        }
                        else {
                            $elemento = $this->db->leggiSingolaRiga($datiComponenteSezione["tabellaRiferimento"],$datiComponenteSezione["idElemento"]);
                            $nomeElemento = filter_var($elemento["nome"],FILTER_SANITIZE_ADD_SLASHES);
                        }
                ?>
                    <div class="azioni">
                        <div class="btn-group" role="group" aria-label="">
                            <button onclick="eliminaComponenteSezione(<?php echo $componenteSezione ?>,<?php echo $datiSezione["id"] ?>,<?php echo $posizioneComponente ?>,'<?php echo $datiComponenteSezione["icona"] ?>','<?php echo $nomeComponenteSezione ?>','<?php echo $nomeElemento ?>','<?php echo $tabellaSezione ?>')" type="button" class="btn btn-sm btn-light elimina" data-toggle="tooltip" data-placement="bottom" title="Rimuovi"><i class="far fa-trash-alt"></i></button>
                        </div>
                    </div>
                    <div class="text-center w-100">
                        <div class="d-flex align-items-center text-center">
                            <div class="w-100">
                                <img src="<?php echo $datiComponenteSezione["icona"] ?>" class="thumb mr-0 d-none d-lg-inline-block">
                                <span class="text-primary"><em><?php echo $datiComponenteSezione["nome"] ?></em></span>
                            </div>
                        </div>

                        <?php 
                            if($datiComponenteSezione["tipo"]!="componenteDinamico" && $datiComponenteSezione["tipo"]!="componenteStrutturaPagina") {
                                $linkModificaComponente = creaLinkModifica($datiComponenteSezione,$linkBaseAreaAmministrativaCMS);
                                $stringaPulsanteModifica = "onclick=\"{location.href='$linkModificaComponente';}\"";

                                ?>
                                <div class="input-group mb-3 w-100 mx-auto d-flex justify-content-center">
                                    <div class="input-group-append">
                                        <select class="form-control form-control-sm" id="idElementoComponente<?php echo $componenteSezione ?>">
                                        <?php
                                            $queryElementiComponente = "SELECT * FROM {$datiComponenteSezione["tabellaRiferimento"]}";
                                            $risElementoComponente   = $this->db->eseguiQueryLettura($queryElementiComponente);
                                            while($elemento = $risElementoComponente->fetch_assoc()) {
                                                if($datiComponenteSezione["idElemento"]==$elemento["id"]) {
                                                    echo"<option value=\"{$elemento["id"]}\" selected >{$elemento["nome"]}</option>";
                                                }
                                                else {
                                                    echo"<option value=\"{$elemento["id"]}\">{$elemento["nome"]}</option>";
                                                }
                                            }
                                        ?>
                                        </select>
                                        <button type="button" class="btn btn-primary btn-sm" onclick="cambiaIdElementoComponenteContenuto(<?php echo $componenteSezione ?>)">Salva</button>
                                    </div>
                                </div>
                                <?php
                            }
                            else {
                                echo"<span class=\"text-truncate text-muted d-block mx-auto\">". substr(strip_tags($datiComponenteSezione["testo"]),0,90)."</span>";
                                $stringaPulsanteModifica = "onclick=\"apriModalModificaComponenteContenuto('../',{$datiComponenteSezione["id"]})\"";
                            }
                        ?>
                        <button type="button" class="btn btn-primary btn-sm text-nowrap my-3"  <?php echo $stringaPulsanteModifica ?>><span class="d-none d-lg-inline-block">Configura</span><i class="far fa-edit fa-fw ml-1"></i></button>
                    </div>
                <?php
                    }
                    else {
                ?>
                        <button type="button" class="btn btn-success btn-sm btn-block mb-3 mb-md-0" onclick="apriPopupAggiungiComponenteSezione(<?php echo $datiSezione["id"] ?>,<?php echo $posizioneComponente ?>,'<?php echo $tabellaSezione ?>')"><i class="fas fa-plus"></i> Aggiungi un componente</button>
                <?php
                    }
                ?>
            </div>
            <?php
        }
        
        /*
         * Esegue l'analisi SEO di un contenuto, viene invocato solo nella pagina
         * contenuti/creaContenuto.php dopo un aggiornamento o dopo la creazione di
         * un nuovo elemento
         */
        function eseguiAnalisiSeo() {

            //variabili che memorizzano l'indicatore per la seo
            $seoPositivo = "<span class=\"badge badge-success p-2\">BUONA</span>";
            $seoDiscreto = "<span class=\"badge badge-warning p-2\">DISCRETA</span>";
            $seoNegativo = "<span class=\"badge badge-danger p-2\">SCADENTE</span>";
        
            $seoPositivoTesto = "buona";
            $seoDiscretoTesto = "discreta";
            $seoNegativoTesto = "scadente";
            $punteggioSeo = 0;

            //inizializzazione array che contiene i risultati
            $analisiSeo = array();
            $suggerimenti = array();
            $analisiSeo["esito"] = $seoNegativo;
            $analisiSeo["esitoTesto"] = $seoNegativoTesto;

            //analisi titolo
            $numeroCaratteriTitolo = strlen($this->nome);
            if ($numeroCaratteriTitolo > 20 && $numeroCaratteriTitolo < 50) {
                $punteggioSeo += 1;
            }

            //analisi meta descrizione
            $numeroCaratteriDescrizione = strlen($this->metaDescrizione);
            if($numeroCaratteriDescrizione==0) {
                $suggerimenti[count($suggerimenti)] = "<p><i class=\"fa fa-exclamation-triangle text-warning\" aria-hidden=\"true\"></i> La <strong>meta descrizione</strong> è assente, inseriscila per migliorare l'indicizzazione di questo contenuto.</p>";
                $punteggioSeo -= 1;
            }
            else if ($numeroCaratteriDescrizione > 0 && $numeroCaratteriDescrizione <= 40) {
                $suggerimenti[count($suggerimenti)] = "<p><i class=\"fa fa-exclamation-triangle text-warning\" aria-hidden=\"true\"></i> La <strong>meta descrizione</strong> è troppo corta, solo $numeroCaratteriDescrizione caratteri. Il numero di caratteri ottimale è tra i 120 e i 160.</p>";
                $punteggioSeo += 1;
            }
            else if($numeroCaratteriDescrizione > 40 && $numeroCaratteriDescrizione < 160) {
                $punteggioSeo += 2;
            }

            //analisi testo
            $numeroCaratteriTesto = $this->contaTesto();
            if($numeroCaratteriTesto == 0) {
                $suggerimenti[count($suggerimenti)] = "<p><i class=\"fa fa-exclamation-triangle text-warning\" aria-hidden=\"true\"></i> Il <strong>testo</strong> è assente, indicizzare questo contenuto sarà molto difficile.</p>";
            }
            else if($numeroCaratteriTesto > 0 && $numeroCaratteriTesto < 700) {
                $suggerimenti[count($suggerimenti)] = "<p><i class=\"fa fa-exclamation-triangle text-warning\" aria-hidden=\"true\"></i> Il <strong>testo</strong> è troppo corto, solo $numeroCaratteriTesto caratteri. Le dimensioni minime sono di almeno 500 caratteri, quelle ottimali oltre i 1000 caratteri.</p>";
            }
            else if ($numeroCaratteriTesto >700 && $numeroCaratteriTesto < 1000) {
                $punteggioSeo += 1;
                $suggerimenti[count($suggerimenti)] = "<p><i class=\"fa fa-exclamation-triangle text-warning\" aria-hidden=\"true\"></i> Il <strong>testo</strong> è un po' corto, $numeroCaratteriTesto caratteri. Le dimensioni ottimali sono di almeno 1000 caratteri.</p>";
            }
            else if ($numeroCaratteriTesto > 1000) {
                $punteggioSeo += 2;
            }

            //analisi presenza immagini
            $numeroImmagini = 0;
            if ($this->foto != "") {
                $numeroImmagini ++;
            }

            if($numeroImmagini>0) {
                $punteggioSeo += 1;
            }
            else {
                $suggerimenti[count($suggerimenti)] = "<p><i class=\"fa fa-exclamation-triangle text-warning\" aria-hidden=\"true\"></i> <strong>Non ci sono immagini</strong> in questo contenuto, inseriscine almeno una.</p>";
            }

            //assegnazione valutazione
            if($punteggioSeo > 5) {
                $analisiSeo["esito"]      = $seoPositivo;
                $analisiSeo["esitoTesto"] = $seoPositivoTesto;
            }
            else if($punteggioSeo == 3 || $punteggioSeo == 4 || $punteggioSeo == 5) {
                $analisiSeo["esito"]      = $seoDiscreto;
                $analisiSeo["esitoTesto"] = $seoDiscretoTesto;
            }
            $analisiSeo["suggerimenti"] = $suggerimenti;
            return $analisiSeo;
        }
        
        /*
         * Questa funzione controlla il testo del contenuto, contando i caratteri della colonan testo e 
         * di ogni componente testo
         */
        function contaTesto() {
            $numeroCaratteriTesto = 0;
            $queryComponenteTesto = "SELECT * FROM geecB_composizionePagine WHERE (idComponente=14 OR idComponente=15 OR idComponente=28) AND idPagina = $this->id AND tipoElemento LIKE 'categoriaSopra'";
            $risComponentiTesto   = $this->db->eseguiQueryLettura($queryComponenteTesto);
            while($componenteTesto = $risComponentiTesto->fetch_assoc()) {
                if($componenteTesto["idComponente"]==28) {
                    $datiSezioneSdoppiata = $this->db->leggiSingolaRiga("geec_sezioniSdoppiate",$componenteTesto["idElemento"]);
                    $numeroCaratteriTesto += strlen(strip_tags($datiSezioneSdoppiata["testo"]));
                }
                else {                
                    $numeroCaratteriTesto += strlen(strip_tags($componenteTesto["testo"]));
                }
            }
            return $numeroCaratteriTesto;
        }
        
        function modificaOpzioniSezioneComponente($id,$idSezione,$classeSezione,$aTuttaLarghezza,$margineSezione,$paddingSezione,$coloreSfondo,$percorsoImmagine,$percorsoFileVideo) {
            $queryModifica = "UPDATE geecB_composizionePagine SET idSezione='$idSezione', classeSezione='$classeSezione', aTuttaLarghezza='$aTuttaLarghezza', margineSezione='$margineSezione', paddingSezione='$paddingSezione', coloreSfondo='$coloreSfondo' WHERE id=$id";
            $this->db->eseguiQueryLettura($queryModifica);
            
            if($percorsoImmagine!="") {
                $queryModifica = "UPDATE geecB_composizionePagine SET immagineSfondo='$percorsoImmagine' WHERE id=$id";
                $this->db->eseguiQueryLettura($queryModifica);
            }
            
            if($percorsoFileVideo!="") {
                $queryModifica = "UPDATE geecB_composizionePagine SET videoSfondo='$percorsoFileVideo' WHERE id=$id";
                $this->db->eseguiQueryLettura($queryModifica);
            }
        }
        
        /*
         * Metodo che consente di stampare il box delle traduzioni che compare nella pagina creaContenuto.php
         * 
         * ha bisogno di recuperare la variabile globale contenente le lingue
         */
        function stampaBoxTraduzioni() {
            $lingue = $GLOBALS["lingue"];
            if($this->getCategoriaRiferimento()==0) {
                $queryTraduzioni = "SELECT * FROM geec_categorie WHERE categoriaRiferimento={$this->getId()} AND tipo LIKE '{$this->getTipo()}'";
            }
            else {
                $queryTraduzioni = "SELECT * FROM geec_categorie WHERE id={$this->getCategoriaRiferimento()} OR (categoriaRiferimento={$this->getCategoriaRiferimento()} AND tipo LIKE '{$this->getTipo()}' AND id!={$this->getId()})";
            }

            $result = $this->db->eseguiQueryLettura($queryTraduzioni);
            if($result->num_rows>0) {
                echo"<hr>
                <p>Traduzioni associate:</p>";                                            
            }

            while($traduzione=$result->fetch_assoc()) {
                unset($lingue[array_search($traduzione["lingua"], $lingue)]);
            ?>
                <div class="d-flex justify-content-between align-items-center mb-2" id="pagina<?php echo $traduzione["id"] ?>">
                    <div>
                        <button type="button" onclick="eliminaPagina(<?php echo $traduzione["id"] ?>,'<?php echo $traduzione["titolo"] ?>')" class="btn btn-light btn-sm mr-1 text-secondary" data-toggle="tooltip" data-placement="bottom" title="" data-original-title="Elimina"><i class="far fa-trash-alt"></i></button>
                        <a href="creaCategoria.php?id=<?php echo $traduzione["id"] ?>"><?php echo $traduzione["nome"] ?></a>
                    </div>
                    <img src="../<?php echo percorsoImmagineBandiera($traduzione["lingua"]) ?>" alt="<?php echo $traduzione["lingua"] ?>">
                </div>
            <?php
                }
            ?>
            <hr>
            <div class="input-group">
                <select class="form-control" id="linguaTraduzione">
                    <option value="">Crea una traduzione...</option>
                    <?php
                        // elimina la lingua del contenuto
                        unset($lingue[array_search($this->getLingua(), $lingue)]);
                        foreach($lingue as $lingua) {
                            echo"<option value=\"$lingua\" >$lingua </option>";
                        }
                    ?>
                </select>
                <div class="input-group-append">
                    <button class="btn btn-primary" type="button" onclick="traduci(<?php echo(($this->getCategoriaRiferimento()==0) ? $this->getId() : $this->getCategoriaRiferimento()) ?>)">Crea</button>
                </div>
            </div>
            <?php
        }
        
        function cambiaImmagine($percorsoFoto) {
            $query = "UPDATE `geec_categorie` SET  foto ='$percorsoFoto' WHERE id=$this->id";
            $this->id = $this->db->eseguiQueryCreazione($query);
        }
        
        function aggiornaPosizione($nuovaPosizione) {
            if($this->categoriaMadre>0) {
                $queryCategorie = "SELECT * FROM geec_categorie WHERE id != $this->id AND tipo LIKE '$this->tipo' AND categoriaMadre=$this->categoriaMadre ORDER BY id ASC";
            }
            else {            
                $queryCategorie = "SELECT * FROM geec_categorie WHERE id != $this->id AND tipo LIKE '$this->tipo' ORDER BY id ASC";
            }
            $risCategorie   = $this->db->eseguiQueryLettura($queryCategorie);
            
            $posizione = 1;
            while($categoria = $risCategorie->fetch_assoc()) {
                if($posizione==$nuovaPosizione) {
                    $posizione++;
                }
                $queryAggiornamentoPosizione = "UPDATE geec_categorie SET posizione=$posizione WHERE id={$categoria["id"]}";
                $this->db->eseguiQueryScrittura($queryAggiornamentoPosizione);
                //echo $queryAggiornamentoPosizione."<br>\n";
                $posizione++;
            }
            
            // infine aggiorno la categoria che oggetto dell'aggiornamento con la posizione data
            $queryAggiornamentoPosizione = "UPDATE geec_categorie SET posizione=$nuovaPosizione WHERE id={$this->id}";
            $this->db->eseguiQueryScrittura($queryAggiornamentoPosizione);
        }

        function sposta($posizione) {
            $queryPosizione = "SELECT * FROM geec_categorie WHERE categoriaMadre=$this->categoriaMadre AND id != $this->id AND tipo LIKE '$this->tipo' ORDER BY posizione ASC";
            $risElementi    = $this->db->eseguiQueryLettura($queryPosizione);
            
            $posizioneCorrente = 1;
            while($elementoCorrente = $risElementi->fetch_assoc()) {
                if($posizione==$posizioneCorrente) {
                    $posizioneCorrente++;
                }
                $queryPosizione = "UPDATE geec_categorie SET posizione=$posizioneCorrente WHERE id = {$elementoCorrente["id"]} ";
                $this->db->eseguiQueryScrittura($queryPosizione);
                $posizioneCorrente ++;
            }
            $queryPosizioneElementoPrincipale = "UPDATE geec_categorie SET posizione=$posizione WHERE id = $this->id ";
            $this->db->eseguiQueryScrittura($queryPosizioneElementoPrincipale);
        }
    
        // GETTER E SETTER
        function getDb() {
            return $this->db;
        }

        function getId() {
            return $this->id;
        }

        function getCategoriaMadre() {
            return $this->categoriaMadre;
        }
        
        public function getCategoriaRiferimento() {
            return $this->categoriaRiferimento;
        }
        
        function getNome() {
            return $this->nome;
        }

        function getTipo() {
            return $this->tipo;
        }

        function getLingua() {
            return $this->lingua;
        }
        
        function getElementiPerPagina() {
            return $this->elementiPerPagina;
        }
        
        function getCssGenerato() {
            return $this->cssGenerato;
        }

        function getCssAggiuntivo() {
            return $this->cssAggiuntivo;
        }
        
        function getFoto() {
            return $this->foto;
        }
        
        function getPosizione() {
            return $this->posizione;
        }

        function getAlias() {
            return $this->alias;
        }

        function getTipoVisualizzazione() {
            return $this->tipoVisualizzazione;
        }
        function getOrdinamento() {
            return $this->ordinamento;
        }
        
        function getTitoloPagina() {
            return $this->titoloPagina;
        }

        function getMetaDescrizione() {
            return $this->metaDescrizione;
        }

        function getPunteggioSeo() {
            return $this->punteggioSeo;
        }
        
        function getDatiCategoria() {
            return $this->datiCategoria;
        }
        
        function setOrdinamento($ordinamento) {
            $this->ordinamento = $ordinamento;
        }

        function setAlias($alias) {
            $this->alias = $alias;
        }

        function setTipoVisualizzazione($tipoVisualizzazione) {
            $this->tipoVisualizzazione = $tipoVisualizzazione;
        }

        function setCssGenerato($cssGenerato): void {
            $this->cssGenerato = $cssGenerato;
        }
        
        function setCssAggiuntivo($cssAggiuntivo): void {
            $this->cssAggiuntivo = $cssAggiuntivo;
        }
        
        function setFoto($foto): void {
            $this->descrizione = $foto;
        }
        
        function setPosizione($posizione): void {
            $this->posizione = $posizione;
        }

        function setDb($db) {
            $this->db = $db;
        }

        function setId($id): void {
            $this->id = $id;
        }

        function setCategoriaMadre($categoriaMadre) {
           $this->categoriaMadre = $categoriaMadre;
        }

        public function setCategoriaRiferimento($categoriaRiferimento): void {
            $this->categoriaRiferimento = $categoriaRiferimento;
        }

        function setNome($nome) {
           $this->nome = $nome;
        }

        function setTipo($tipo) {
           $this->tipo = $tipo;
        }

        function setLingua($lingua) {
           $this->lingua = $lingua;
        }
        
        function setElementiPerPagina($elementiPerPagina) {
           $this->elementiPerPagina = $elementiPerPagina;
        }

        function setTitoloPagina($titoloPagina) {
            $this->titoloPagina = $titoloPagina;
        }

        function setMetaDescrizione($metaDescrizione) {
            $this->metaDescrizione = $metaDescrizione;
        }

        function setPunteggioSeo($punteggioSeo) {
            $this->punteggioSeo = $punteggioSeo;
        }
    }